

#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     LightSeaGreen
#property indicator_color2     Red
#property indicator_color3     RoyalBlue
#property indicator_color4     RoyalBlue
#property indicator_color5     RoyalBlue
#property indicator_minimum    -5
#property indicator_maximum    100
#property indicator_levelcolor MediumOrchid

//
//
//
//
//

extern int               StoKPeriod                   = 14;
extern int               StoDPeriod                   = 3;
extern int               StoSlowing                   = 3;
extern ENUM_STO_PRICE    PriceField                   = 0;
extern ENUM_MA_METHOD    SignalMode                   = MODE_SMA;
extern double            BandsPeriod                  = 20; 
extern ENUM_MA_METHOD    BandsMethod                  = MODE_SMA;
extern double            BandsDeviations              = 2.0;
extern double            levelOb                      = 80;
extern double            levelOs                      = 20;

extern bool   alertsOn                     = true;
extern bool   alertsOnOuterBandCross       = true;
extern bool   alertsOnMidBandCross         = true;
extern bool   alertsOnOuterBandCross2      = true;
extern bool   alertsOnCurrent              = true;
extern bool   alertsMessage                = true;
extern bool   alertsSound                  = false;
extern bool   alertsNotify                 = false;
extern bool   alertsEmail                  = false;

extern bool   arrowsVisible                = false;
extern string arrowsIdentifier             = "stoch bands arrows1";
extern double arrowsUpperGap               = 1.0;
extern double arrowsLowerGap               = 1.0;

extern bool   arrowsOnOuterBandCross       = true;
extern color  arrowsOuterBandCrossUpColor  = LimeGreen;
extern color  arrowsOuterBandCrossDnColor  = Red;
extern int    arrowsOuterBandCrossUpCode   = 241;
extern int    arrowsOuterBandCrossDnCode   = 242;
extern int    arrowsOuterBandCrossSize     = 2;

extern bool   arrowsOnMidBandCross         = true;
extern color  arrowsMidBandCrossUpColor    = DeepSkyBlue;
extern color  arrowsMidBandCrossDnColor    = PaleVioletRed;
extern int    arrowsMidBandCrossUpCode     = 241;
extern int    arrowsMidBandCrossDnCode     = 242;
extern int    arrowsMidBandCrossSize       = 4;

extern bool   arrowsOnOuterBandCross2      = true;
extern color  arrowsOuterBandCross2UpColor = LimeGreen;
extern color  arrowsOuterBandCross2DnColor = Red;
extern int    arrowsOuterBandCross2UpCode  = 241;
extern int    arrowsOuterBandCross2DnCode  = 242;
extern int    arrowsOuterBandCross2Size    = 2;


//
//
//
//
//

double sto[];
double sig[];
double bbMa[];
double bbDn[];
double bbUp[];
double trend1[];
double trend2[];
double trend3[];

//
//
//
//
//

int init()
{
   IndicatorBuffers(8);
   SetIndexBuffer(0,sto);
   SetIndexBuffer(1,sig);
   SetIndexBuffer(2,bbMa);
   SetIndexBuffer(3,bbUp);
   SetIndexBuffer(4,bbDn);
   SetIndexBuffer(5,trend1);
   SetIndexBuffer(6,trend2);
   SetIndexBuffer(7,trend3);
   SetLevelValue(0,50);
   SetLevelValue(1,levelOs);
   SetLevelValue(2,levelOb);
   IndicatorShortName("Stoch bands");
return(0);
}

int deinit()
{
   deleteArrows(); 

return(0);
}


//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
   int i,limit;
   
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
           limit = MathMin(Bars-counted_bars,Bars-1);
           
   //
   //
   //
   //
   //
   
   for (i=limit; i>=0; i--)sto[i] = iStochastic(NULL,0,StoKPeriod,StoDPeriod,StoSlowing,SignalMode,PriceField,MODE_MAIN  ,i);
   for (i=limit; i>=0; i--)sig[i] = iStochastic(NULL,0,StoKPeriod,StoDPeriod,StoSlowing,SignalMode,PriceField,MODE_SIGNAL,i);     
   for (i=limit; i>=0; i--)
   {  
      bbMa[i] = iBandsOnArray(sto,0,BandsPeriod,BandsDeviations,0,MODE_MAIN, i);
      bbUp[i] = iBandsOnArray(sto,0,BandsPeriod,BandsDeviations,0,MODE_UPPER,i);
      bbDn[i] = iBandsOnArray(sto,0,BandsPeriod,BandsDeviations,0,MODE_LOWER,i);
      trend1[i] = 0;
      trend2[i] = trend2[i+1];
      trend3[i] = 0;
        if (sto[i]>bbUp[i]) trend1[i] = 1;
        if (sto[i]<bbDn[i]) trend1[i] =-1; 
        if (sto[i]>bbMa[i]) trend2[i] = 1;
        if (sto[i]<bbMa[i]) trend2[i] =-1;
        if (sto[i]>bbUp[i]) trend3[i] = 1;
        if (sto[i]<bbDn[i]) trend3[i] =-1;  
        manageArrow(i);
   }
   manageAlerts();   
return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void manageArrow(int i)
{
   if (arrowsVisible)
   {
      ObjectDelete(arrowsIdentifier+":1:"+Time[i]);
      ObjectDelete(arrowsIdentifier+":2:"+Time[i]);
      ObjectDelete(arrowsIdentifier+":3:"+Time[i]);
      string lookFor = arrowsIdentifier+":"+Time[i]; ObjectDelete(lookFor);
      if (arrowsOnOuterBandCross && trend1[i] != trend1[i+1])
      {
         if (trend1[i+1] == -1 && trend1[i] !=-1) drawArrow("1",0.5,i,arrowsOuterBandCrossUpColor,arrowsOuterBandCrossUpCode,arrowsOuterBandCrossSize,false);
         if (trend1[i+1] ==  1 && trend1[i] != 1) drawArrow("1",0.5,i,arrowsOuterBandCrossDnColor,arrowsOuterBandCrossDnCode,arrowsOuterBandCrossSize, true);
      } 
      if (arrowsOnMidBandCross && trend2[i] != trend2[i+1])
      {
         if (trend2[i] == 1) drawArrow("2",1,i,arrowsMidBandCrossUpColor,arrowsMidBandCrossUpCode,arrowsMidBandCrossSize,false);
         if (trend2[i] ==-1) drawArrow("2",1,i,arrowsMidBandCrossDnColor,arrowsMidBandCrossDnCode,arrowsMidBandCrossSize, true);
      } 
      if (arrowsOnOuterBandCross2 && trend3[i] != trend3[i+1])
      {
         if (trend3[i] == 1) drawArrow("3",1.5,i,arrowsOuterBandCross2UpColor,arrowsOuterBandCross2UpCode,arrowsOuterBandCross2Size,false);
         if (trend3[i] ==-1) drawArrow("3",1.5,i,arrowsOuterBandCross2DnColor,arrowsOuterBandCross2DnCode,arrowsOuterBandCross2Size, true);
      }                                     
   }         
}       

//
//
//
//
//

void drawArrow(string nameAdd, double gapMul, int i,color theColor,int theCode,int theWidth,bool up)
{
   string name = arrowsIdentifier+":"+nameAdd+":"+Time[i];
   double gap  = iATR(NULL,0,20,i)*gapMul;   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_WIDTH,theWidth);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; 
      
      //
      //
      //
      //
      //
      
      static datetime time1 = 0;
      static string   mess1 = "";
         if (alertsOnOuterBandCross && trend1[whichBar] != trend1[whichBar+1])
         {
            if (trend1[whichBar+1] == 1 && trend1[whichBar] != 1) doAlert(time1,mess1,whichBar," crossing upper band down");
            if (trend1[whichBar+1] ==-1 && trend1[whichBar] !=-1) doAlert(time1,mess1,whichBar," crossing lower band up");
         }            
      static datetime time2 = 0;
      static string   mess2 = "";
         if (alertsOnMidBandCross && trend2[whichBar] != trend2[whichBar+1])
         {
            if (trend2[whichBar] == 1) doAlert(time2,mess2,whichBar," crossing middle band up");
            if (trend2[whichBar] ==-1) doAlert(time2,mess2,whichBar," crossing middle band down");
         } 
      static datetime time3 = 0;
      static string   mess3 = "";
         if (alertsOnOuterBandCross2 && trend3[whichBar] != trend3[whichBar+1])
         {
            if (trend3[whichBar] == 1) doAlert(time3,mess3,whichBar," crossing outer band up");
            if (trend3[whichBar] ==-1) doAlert(time3,mess3,whichBar," crossing lower band down");
         } 
                          
   }
}   

//
//
//
//
//

void doAlert(datetime& previousTime, string& previousAlert, int forBar, string doWhat)
{
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

          message = StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Stochastic bands ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Stochastic bands "),message);
             if (alertsSound)   PlaySound("alert2.wav");
      }
}





